// FieldGuardian Compliance Overlay Popup Script

// DOM elements
const apiEndpointInput = document.getElementById('api-endpoint');
const enableAnalysisToggle = document.getElementById('enable-analysis');
const notifyCompletionToggle = document.getElementById('notify-completion');
const saveSettingsButton = document.getElementById('save-settings');
const formsAnalyzedElement = document.getElementById('forms-analyzed');
const avgScoreElement = document.getElementById('avg-score');
const statusTextElement = document.getElementById('status-text');

// Load settings and stats when popup opens
document.addEventListener('DOMContentLoaded', () => {
  // Load settings from storage
  chrome.storage.sync.get(
    {
      apiEndpoint: 'https://api.fieldguardian.com/analyze',
      enableAnalysis: true,
      notifyOnCompletion: true
    },
    (items) => {
      apiEndpointInput.value = items.apiEndpoint;
      enableAnalysisToggle.checked = items.enableAnalysis;
      notifyCompletionToggle.checked = items.notifyOnCompletion;
    }
  );
  
  // Load statistics
  chrome.storage.sync.get(
    {
      formsAnalyzed: 0,
      averageScore: 0.0
    },
    (items) => {
      formsAnalyzedElement.textContent = items.formsAnalyzed;
      avgScoreElement.textContent = items.averageScore.toFixed(1);
    }
  );
  
  // Check if extension is active on current page
  chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    const currentTab = tabs[0];
    
    // Update status based on URL (simplified for demo)
    if (currentTab.url.startsWith('http')) {
      statusTextElement.textContent = 'Active on this page';
      document.querySelector('.status-dot').classList.add('active');
    } else {
      statusTextElement.textContent = 'Inactive on this page';
      document.querySelector('.status-dot').classList.remove('active');
    }
  });
});

// Save settings when the save button is clicked
saveSettingsButton.addEventListener('click', () => {
  chrome.storage.sync.set(
    {
      apiEndpoint: apiEndpointInput.value,
      enableAnalysis: enableAnalysisToggle.checked,
      notifyOnCompletion: notifyCompletionToggle.checked
    },
    () => {
      // Show saved confirmation
      saveSettingsButton.textContent = 'Saved!';
      saveSettingsButton.classList.add('saved');
      
      // Reset button after a short delay
      setTimeout(() => {
        saveSettingsButton.textContent = 'Save Settings';
        saveSettingsButton.classList.remove('saved');
      }, 1500);
    }
  );
});